<?php

class AssetController extends Controller
{
/**
* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
* using two-column layout. See 'protected/views/layouts/column2.php'.
*/
public $layout='//layouts/column1';

/**
* @return array action filters
*/
public function filters()
{
return array(
'accessControl', // perform access control for CRUD operations
);
}

/**
* Specifies the access control rules.
* This method is used by the 'accessControl' filter.
* @return array access control rules
*/
public function accessRules()
{
return array(
array('allow',  // allow all users to perform 'index' and 'view' actions
'actions'=>array('index','view','RegisteAsset','GetIssuedAssets','UpdateIssuedStatus','GetAssetsDetails'),
'users'=>array('*'),
),
array('allow', // allow authenticated user to perform 'create' and 'update' actions
'actions'=>array('create','update'),
'users'=>array('@'),
),
array('allow', // allow admin user to perform 'admin' and 'delete' actions
'actions'=>array('admin','delete'),
'users'=>array('admin'),
),
array('deny',  // deny all users
'users'=>array('*'),
),
);
}

/**
* Displays a particular model.
* @param integer $id the ID of the model to be displayed
*/
public function actionView($id)
{
$this->render('view',array(
'model'=>$this->loadModel($id),
));
}

/**
* Creates a new model.
* If creation is successful, the browser will be redirected to the 'view' page.
*/
public function actionCreate()
{
$model=new Asset;

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['Asset']))
{
$model->attributes=$_POST['Asset'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('create',array(
'model'=>$model,
));
}

/**
* Updates a particular model.
* If update is successful, the browser will be redirected to the 'view' page.
* @param integer $id the ID of the model to be updated
*/
public function actionUpdate($id)
{
$model=$this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['Asset']))
{
$model->attributes=$_POST['Asset'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('update',array(
'model'=>$model,
));
}

/**
* Deletes a particular model.
* If deletion is successful, the browser will be redirected to the 'admin' page.
* @param integer $id the ID of the model to be deleted
*/
public function actionDelete($id)
{
if(Yii::app()->request->isPostRequest)
{
// we only allow deletion via POST request
$this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
if(!isset($_GET['ajax']))
$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
}
else
throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
}

/**
* Lists all models.
*/
public function actionIndex()
{
$dataProvider=new CActiveDataProvider('Asset');
$this->render('index',array(
'dataProvider'=>$dataProvider,
));
}

/**
* Manages all models.
*/
public function actionAdmin()
{
$model=new Asset('search');
$model->unsetAttributes();  // clear any default values
if(isset($_GET['Asset']))
$model->attributes=$_GET['Asset'];

$this->render('admin',array(
'model'=>$model,
));
}

public function actionRegisteAsset(){
    
    $model = new Asset;

    $body = @file_get_contents('php://input');
    $obj = json_decode($body);

    $model->uid = $obj->uid;
    $model->serial = $obj->serial;
    $model->type = $obj->type;

    if($model->save()){
        $this->_sendResponse(200, CJSON::encode(array("status"=>1)));
    }else{
        $this->_sendResponse(200, CJSON::encode(array("status"=>0)));
    }
}

public function actionGetAssetsDetails(){
    $body = @file_get_contents('php://input');
    $obj = json_decode($body);

    $list = Yii::app()->db->createCommand("SELECT A.*,AT.name
    FROM asset A
    INNER JOIN assettypes AT on AT.id = A.type
    WHERE uid = '".$obj->uid."'")->queryAll();

    if(count($list) != 0){
        $this->_sendResponse(200, CJSON::encode($list));
    }else{
        $this->_sendResponse(200, CJSON::encode(array("status"=>0)));
    } 
}

public function actionGetIssuedAssets(){
    //Search for t-shirt issues for the relevant employee  

    $employeeid = $_POST['Employeeid'];
    $issuedAssets = EmployeeAsset::model()->findAllBySql("select * from employee_asset where empID = $employeeid");
    $employee = Employee::model()->findByPk($employeeid);

    foreach($issuedAssets as $issuedAsset){

        $asset = Asset::model()->findByPk($issuedAsset->assetId);

        echo '<tr>';
        echo '<td>'.$asset->serial.' : '.$asset->type.'</td>'; 
        echo '<td>'.$issuedAsset->issuedDate.'</td>';
    
        if($issuedAsset->Status=='Returned'){
            echo '<td>'.$issuedAsset->returnedDate.'</td>';
            echo '<td>'.$issuedAsset->Status.'</td>';
            echo '<td> 
                <input type="checkbox" checked="checked" name="myTextEditBox1" value='.$issuedAsset->id.' onchange="changeContentTshirtIssues('.$issuedAsset->id.',this.checked)"
                style="margin-left:auto; margin-right:auto;">
                </td>';
        }

        else{
            echo '<td>'.'0000-00-00'.'</td>';
            echo '<td>'.$issuedAsset->Status.'</td>';
            echo '<td> 
                <input type="checkbox" name="myTextEditBox1" value='.$issuedAsset->id.' onchange="changeContentTshirtIssues('.$issuedAsset->id.',this.checked)"
                style="margin-left:auto; margin-right:auto;">
                </td>';
            
        }
      
        echo '</tr>';
    }
}

public function actionUpdateIssuedStatus(){
 
    $issueID =$_POST['AssetId'];
    $status =$_POST['Status'];

    if($status=='true'){
        EmployeeAsset::model()->updateAll(array('returnedDate'=>date('Y-m-d'),'Status' => 'Returned'),"id=" .$issueID."" );
    }
    else{
        EmployeeAsset::model()->updateAll(array('returnedDate'=>null,'Status' => 'Not Returned'),"id=" .$issueID."");
    }  
}


/**
* Returns the data model based on the primary key given in the GET variable.
* If the data model is not found, an HTTP exception will be raised.
* @param integer the ID of the model to be loaded
*/
public function loadModel($id)
{
$model=Asset::model()->findByPk($id);
if($model===null)
throw new CHttpException(404,'The requested page does not exist.');
return $model;
}

/**
* Performs the AJAX validation.
* @param CModel the model to be validated
*/
protected function performAjaxValidation($model)
{
if(isset($_POST['ajax']) && $_POST['ajax']==='asset-form')
{
echo CActiveForm::validate($model);
Yii::app()->end();
}
}
}
