<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');
Yii::setPathOfAlias('bootstrap', dirname(__FILE__) . '/../extensions/bootstrap');
Yii::setPathOfAlias('chartjs', dirname(__FILE__) . '/../extensions/yii-chartjs');
Yii::setPathOfAlias('curl', dirname(__FILE__) . '/../extensions/curl');
Yii::setPathOfAlias('pdfext', dirname(__FILE__) . '/../extensions/yii-pdf');
Yii::setPathOfAlias('excel', dirname(__FILE__) . '/../extensions/yiiexcel');
Yii::setPathOfAlias('mailer', dirname(__FILE__) . '/../extensions/YiiMailer');

Yii::import('excel.YiiExcel', true);
Yii::import('mailer.YiiMailer', true);
Yii::registerAutoloader(array('YiiExcel', 'autoload'), true);

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
    'basePath' => dirname(__FILE__) . DIRECTORY_SEPARATOR . '..',
    'name' => '',
    //'bootstrap' => ['log'],
    'aliases' => array(
        'bootstrap' => realpath(__DIR__ . '/../extensions/bootstrap'), // change this if necessary
    ),
    // preloading 'log' component
    'preload' => array('log', 'chartjs',),
    // autoloading model and component classes
    'import' => array(
        'application.models.*',
        'application.components.*',
        'application.modules.user.models.*',
        'application.modules.user.components.*',
        'application.vendors.phpexcel.PHPExcel',
        //'application.components.emailF.Email',  
    ),
    'modules' => array(
        'user' => array(
            'debug' => true,
        ),
        'usergroup' => array(
            'usergroupTable' => 'usergroup',
            'usergroupMessageTable' => 'user_group_message',
        ),
        'membership' => array(
            'membershipTable' => 'membership',
            'paymentTable' => 'payment',
        ),
        'friendship' => array(
            'friendshipTable' => 'friendship',
        ),
        'profile' => array(
            'privacySettingTable' => 'privacysetting',
            'profileFieldTable' => 'profile_field',
            'profileTable' => 'profile',
            'profileCommentTable' => 'profile_comment',
            'profileVisitTable' => 'profile_visit',
        ),
        'role' => array(
            'roleTable' => 'role',
            'userRoleTable' => 'user_role',
            'actionTable' => 'action',
            'permissionTable' => 'permission',
        ),
        'message' => array(
            'messageTable' => 'message',
        ),
        'gii' => array(
            'class' => 'system.gii.GiiModule',
            'password' => '12345',
            // If removed, Gii defaults to localhost only. Edit carefully to taste.
            //'ipFilters' => array('127.0.0.1', '10.1.28.1', '10.1.24.252'),
            'generatorPaths' => array(
                'bootstrap.gii',
            ),
        ),
    ),
    // application components
    'components' => array(
        'metadata'=>array('class'=>'Metadata'),
        'cache' => array('class' => 'system.caching.CDummyCache'),
        'paymentUtil'=>array('class'=>'PaymentUtil'),
        'HolidayRateUtil'=>array('class'=>'HolidayRateUtil'),
        'PayrollCalculationUtil'=>array('class'=>'PayrollCalculationUtil'),
        'bootstrap' => array(
            'class' => 'bootstrap.components.Bootstrap',
            'responsiveCss' => true,
        ),
        'user' => array(
            'class' => 'application.modules.user.components.YumWebUser',
            'allowAutoLogin' => true,
            'loginUrl' => array('//user/user/login'),
        ),
        'urlManager' => array(
            'urlFormat' => 'path',
            'rules' => array(

                array('TreemapApi/GetAllCompany', 'pattern' => 'treemapapi/getallcompany', 'verb' => 'GET'),
                array('TreemapApi/GetAllSector', 'pattern' => 'treemapapi/getallsector', 'verb' => 'GET'),
                array('RosterApi/GetAllRoster', 'pattern' => 'RosterApi/getallroster', 'verb' => 'GET'),
                array('HolydayApi/GetAllHolydas', 'pattern' => 'HolydayApi/getallholydas', 'verb' => 'GET'),

                array('loginapi/login', 'pattern' => 'loginapi/login', 'verb' => 'POST'),
                array('userApi/securityusers', 'pattern' => 'userapi/securityusers', 'verb' => 'GET'),
                array('userApi/getallusers', 'pattern' => 'userapi/getallusers', 'verb' => 'GET'),
                array('scheduleApi/getschedulebyvehicle', 'pattern' => 'scheduleapi/getschedulebyvehicle', 'verb' => 'POST'),
                array('scheduleApi/getaccountbyid', 'pattern' => 'scheduleapi/getaccountbyid', 'verb' => 'POST'),
                array('scheduleApi/getuserbyid', 'pattern' => 'scheduleapi/getuserbyid', 'verb' => 'POST'),
                array('scheduleApi/getvisitorsbyschedule', 'pattern' => 'scheduleapi/getvisitorsbyschedule', 'verb' => 'POST'),
                array('scheduleApi/assigncard', 'pattern' => 'scheduleapi/assigncard', 'verb' => 'POST'),
                array('scheduleApi/getvehiclesbyschedule', 'pattern' => 'scheduleapi/getvehiclesbyschedule', 'verb' => 'POST'),
                array('scheduleApi/schedulereturncards', 'pattern' => 'scheduleapi/schedulereturncards', 'verb' => 'POST'),
                array('scheduleApi/schedulereturncardstest', 'pattern' => 'scheduleapi/schedulereturncardstest', 'verb' => 'POST'),
                array('scheduleApi/getexsistingcontactsbynic', 'pattern' => 'scheduleapi/getexsistingcontactsbynic', 'verb' => 'POST'),
                array('scheduleApi/getaccounts', 'pattern' => 'scheduleapi/getaccounts', 'verb' => 'POST'),
                array('scheduleApi/createvisitor', 'pattern' => 'scheduleapi/createvisitor', 'verb' => 'POST'),
                array('scheduleApi/createschedule', 'pattern' => 'scheduleapi/createschedule', 'verb' => 'POST'),
                array('scheduleApi/createschedulevisitor', 'pattern' => 'scheduleapi/createschedulevisitor', 'verb' => 'POST'),
                array('scheduleApi/createschedulevehicle', 'pattern' => 'scheduleapi/createschedulevehicle', 'verb' => 'POST'),
                array('scheduleApi/getvehiclebyplate', 'pattern' => 'scheduleapi/getvehiclebyplate', 'verb' => 'POST'),
                array('scheduleApi/createvehiclebyplate', 'pattern' => 'scheduleapi/createvehiclebyplate', 'verb' => 'POST'),
                array('scheduleApi/completeschedule', 'pattern' => 'scheduleapi/completeschedule', 'verb' => 'POST'),
                array('scheduleApi/opengate', 'pattern' => 'scheduleapi/opengate', 'verb' => 'POST'),
                array('scheduleApi/getuserbyepc', 'pattern' => 'scheduleapi/getuserbyepc', 'verb' => 'POST'),
                array('scheduleApi/getseatbyfloor', 'pattern' => 'scheduleapi/getseatbyfloor', 'verb' => 'POST'),
                array('scheduleApi/deallocateseat', 'pattern' => 'scheduleapi/deallocateseat', 'verb' => 'POST'),
                array('scheduleApi/allocateseat', 'pattern' => 'scheduleapi/allocateseat', 'verb' => 'POST'),
                array('scheduleApi/getseatusers', 'pattern' => 'scheduleapi/getseatusers', 'verb' => 'POST'),
                array('scheduleApi/getschedulebynic', 'pattern' => 'scheduleapi/getschedulebynic', 'verb' => 'POST'),
                array('scheduleApi/updateattendance', 'pattern' => 'scheduleapi/updateattendance', 'verb' => 'POST'),
                array('scheduleApi/getuserbyactivecard', 'pattern' => 'scheduleapi/getuserbyactivecard', 'verb' => 'POST'),
                array('scheduleApi/updateattendancetest', 'pattern' => 'scheduleapi/updateattendancetest', 'verb' => 'POST'),
                array('scheduleApi/getuserbyactivecardtest', 'pattern' => 'scheduleapi/getuserbyactivecardtest', 'verb' => 'POST'),
                array('scheduleApi/getwifitoken', 'pattern' => 'scheduleapi/getwifitoken', 'verb' => 'POST'),
                array('scheduleApi/updatewifitokens', 'pattern' => 'scheduleapi/updatewifitokens', 'verb' => 'POST'),
                array('scheduleApi/writeguestbook', 'pattern' => 'scheduleapi/writeguestbook', 'verb' => 'POST'),
                array('scheduleApi/writeguestbooktest', 'pattern' => 'scheduleapi/writeguestbooktest', 'verb' => 'POST'),
                array('scheduleApi/getguestbookrecord', 'pattern' => 'scheduleapi/getguestbookrecord', 'verb' => 'POST'),
                array('scheduleApi/getguestbookrecords', 'pattern' => 'scheduleapi/getguestbookrecords', 'verb' => 'POST'),
                array('scheduleApi/approveguestbookrecord', 'pattern' => 'scheduleapi/approveguestbookrecord', 'verb' => 'POST'),
                array('scheduleApi/getcardstats', 'pattern' => 'scheduleapi/getcardstats', 'verb' => 'POST'),
                array('scheduleApi/getcardtypebyepc', 'pattern' => 'scheduleapi/getcardtypebyepc', 'verb' => 'POST'),
                array('contractworkerApi/getexsistingworkerbynic', 'pattern' => 'contractworkerapi/getexsistingworkerbynic', 'verb' => 'POST'),
                array('contractworkerApi/createworker', 'pattern' => 'contractworkerapi/createworker', 'verb' => 'POST'),
                array('contractworkerApi/markattendance', 'pattern' => 'contractworkerapi/aarkattendance', 'verb' => 'POST'),
                array('mail/sendmail', 'pattern' => 'mail/sendmail', 'verb' => 'POST'),
                array('mail/sendmailkiosk', 'pattern' => 'mail/sendmailkiosk', 'verb' => 'POST'),
                array('mail/sendmailvipvisit', 'pattern' => 'mail/sendmailvipvisit', 'verb' => 'POST'),
                array('mail/sendmailtest', 'pattern' => 'mail/sendmailtest', 'verb' => 'POST'),
                array('attendanceApi/updateattendance', 'pattern' => 'attendanceApi/updateattendance', 'verb' => 'POST'),
                array('attendanceApi/updatezone', 'pattern' => 'attendanceApi/updatezone', 'verb' => 'POST'),
                array('attendanceApi/getuserslastdetectedtimes', 'pattern' => 'attendanceApi/getuserslastdetectedtimes', 'verb' => 'POST'),
                array('attendanceApi/updateattendancelog', 'pattern' => 'attendanceApi/updateattendancelog', 'verb' => 'POST'),
                array('userbyzoneApi/getcountbyzone', 'pattern' => 'userbyzoneapi/getcountbyzone', 'verb' => 'POST'),
                array('userbyzoneApi/getusersbyzone', 'pattern' => 'userbyzoneapi/getusersbyzone', 'verb' => 'POST'),
                array('attendanceApi/getfailedattendancerecords', 'pattern' => 'attendanceApi/getfailedattendancerecords', 'verb' => 'POST'),
                array('attendanceApi/updatefailedattendance', 'pattern' => 'attendanceApi/updatefailedattendance', 'verb' => 'POST'),
                array('attendanceApi/updatefailedattendance', 'pattern' => 'attendanceApi/updatefailedattendance', 'verb' => 'POST'),
                '<controller:\w+>/<id:\d+>' => '<controller>/view',
                '<controller:\w+>/<action:\w+>/<id:\d+>' => '<controller>/<action>',
                '<controller:\w+>/<action:\w+>' => '<controller>/<action>',
                
            ),
        ),
        'db' => array(
            'connectionString' => 'mysql:host=localhost;dbname=smartassetdb',
            'emulatePrepare' => true,

            'username' => 'eimuser',
            'password' => 'rfid@eimsky2014',
            'charset' => 'utf8',
        ),
        'errorHandler' => array(
            // use 'site/error' action to display errors
            'errorAction' => 'site/error',
        ),
        'curl' => array(
            'class' => 'curl.Curl',
            'options' => array(),
        ),
        'chartjs' => array('class' => 'chartjs.components.ChartJs'),
        'log' => array(
            'class' => 'CLogRouter',
            'routes' => array(
                array(
                    'class' => 'CFileLogRoute',
                    'levels' => 'error, warning',
                ),
                // uncomment the following to show log messages on web pages
                array(
                    'class' => 'CWebLogRoute',
                ),
            ),
        ),
        'ePdf' => array(
            'class' => 'pdfext.EYiiPdf',
            'params' => array(
                'mpdf' => array(
                    'librarySourcePath' => 'application.vendors.mpdf.*',
                    'constants' => array(
                        '_MPDF_TEMP_PATH' => Yii::getPathOfAlias('application.runtime'),
                    ),
                    'class' => 'mpdf', // the literal class filename to be loaded from the vendors folder
                /* 'defaultParams'     => array( // More info: http://mpdf1.com/manual/index.php?tid=184
                  'mode'              => '', //  This parameter specifies the mode of the new document.
                  'format'            => 'A4', // format A4, A5, ...
                  'default_font_size' => 0, // Sets the default document font size in points (pt)
                  'default_font'      => '', // Sets the default font-family for the new document.
                  'mgl'               => 15, // margin_left. Sets the page margins for the new document.
                  'mgr'               => 15, // margin_right
                  'mgt'               => 16, // margin_top
                  'mgb'               => 16, // margin_bottom
                  'mgh'               => 9, // margin_header
                  'mgf'               => 9, // margin_footer
                  'orientation'       => 'P', // landscape or portrait orientation
                  ) */
                ),
                'HTML2PDF' => array(
                    'librarySourcePath' => 'application.vendors.html2pdf.*',
                    'classFile' => 'html2pdf.class.php', // For adding to Yii::$classMap
                /* 'defaultParams'     => array( // More info: http://wiki.spipu.net/doku.php?id=html2pdf:en:v4:accueil
                  'orientation' => 'P', // landscape or portrait orientation
                  'format'      => 'A4', // format A4, A5, ...
                  'language'    => 'en', // language: fr, en, it ...
                  'unicode'     => true, // TRUE means clustering the input text IS unicode (default = true)
                  'encoding'    => 'UTF-8', // charset encoding; Default is UTF-8
                  'marges'      => array(5, 5, 5, 8), // margins by default, in order (left, top, right, bottom)
                  ) */
                )
            ),
        ),
    ),
    // application-level parameters that can be accessed
    // using Yii::app()->params['paramName']
    'params' => array(
        'ldap' => array(
            'servers' => array(
                '10.1.150.2',
            ),
            'defaultDomain' => 'expo',
            'ldaphost' => 'expo.ad',
            'ldapuser' => 'cmsAdmin',
            'ldappassword' => 'sdfsdfs@sdfsdfsd',
            'ldapdn' => 'DC=expo,DC=ad',
            'search' => array(
                'DC=expo,DC=ad',
            ),
        ),
        // this is used in contact page
        //'adminEmail' => 'thilinamx@gmail.com',
		'adminEmail' => 'lasithitfac@gmail.com',
        //'mailServer' => '10.2.20.30',
        'YiiMailer'=>array(
            'Mailer' => 'smtp',
            'Host' => 'smtp.gmail.com',
            'Port' => 465,
            'SMTPSecure' => 'ssl',
            'SMTPDebug' => 2,
            'SMTPAuth' => true,
            'Username' => 'achinilv@gmail.com',
            'Password' => '921841310',
            'viewPath' => 'application.views.mail',
            'layoutPath' => 'application.views.layouts',
            'baseDirPath' => 'webroot.images.mail', //note: 'webroot' alias in console apps may not be the same as in web apps
            'savePath' => 'webroot.assets.mail',
            'testMode' => false,
            'layout' => 'mail',
            'CharSet' => 'UTF-8',
            'AltBody' => Yii::t('YiiMailer', 'You need an HTML capable viewer to read this message.'),
            'language' => array(
                'authenticate' => Yii::t('YiiMailer', 'SMTP Error: Could not authenticate.'),
                'connect_host' => Yii::t('YiiMailer', 'SMTP Error: Could not connect to SMTP host.'),
                'data_not_accepted' => Yii::t('YiiMailer', 'SMTP Error: Data not accepted.'),
                'empty_message' => Yii::t('YiiMailer', 'Message body empty'),
                'encoding' => Yii::t('YiiMailer', 'Unknown encoding: '),
                'execute' => Yii::t('YiiMailer', 'Could not execute: '),
                'file_access' => Yii::t('YiiMailer', 'Could not access file: '),
                'file_open' => Yii::t('YiiMailer', 'File Error: Could not open file: '),
                'from_failed' => Yii::t('YiiMailer', 'The following From address failed: '),
                'instantiate' => Yii::t('YiiMailer', 'Could not instantiate mail function.'),
                'invalid_address' => Yii::t('YiiMailer', 'Invalid address'),
                'mailer_not_supported' => Yii::t('YiiMailer', ' mailer is not supported.'),
                'provide_address' => Yii::t('YiiMailer', 'You must provide at least one recipient email address.'),
                'recipients_failed' => Yii::t('YiiMailer', 'SMTP Error: The following recipients failed: '),
                'signing' => Yii::t('YiiMailer', 'Signing Error: '),
                'smtp_connect_failed' => Yii::t('YiiMailer', 'SMTP Connect() failed.'),
                'smtp_error' => Yii::t('YiiMailer', 'SMTP server error: '),
                'variable_set' => Yii::t('YiiMailer', 'Cannot set or reset variable: ')
            ),
        ),
    ),
);
