<?php
/**
 * Send email with attachement
 */
include_once('include/globals.php');
include_once('class.phpmailer.php');
include_once('class.smtp.php'); // note, this is optional - gets called from main class if not already loaded


class Email



{
	public static function sendMail($attachments, $email, $cc = '', $subject, $body, $sender)
	{
		
		try {
			$mail = new PHPMailer();
			$mail->IsSMTP();

			$mail->SMTPAuth = false;                  // enable SMTP authentication
 			$mail->SMTPDebug  = 2; // errors and messages
			//$mail->SMTPSecure = 'tls';                 // sets the prefix to the servier
			$mail->Host = EMAIL_SERVER;
			$mail->Port = EMAIL_SERVER_PORT;                   // set the SMTP port
 			$mail->Username   = EMAIL_USER_ACC;
			$mail->Password   = EMAIL_USER_PW;
			$mail->SMTPSecure = false;
			

			// MAIL HEADERS with attachment
			$mail->Subject = $subject;
			if ($sender){
				// error_log('from '.___LINE__);
				$mail->From = $sender;
				$mail->FromName = EMAIL_FROM_NAME;
			}else{
				// error_log('from '.___LINE__);
				$mail->From = EMAIL_FROM_ADDRESS;
				$mail->FromName = EMAIL_FROM_NAME;
			}
			//
			$mail->WordWrap = 50; // set word wrap
			$mail->MsgHTML($body);
			//$mail->AddReplyTo(EMAIL_USER_ACC, EMAIL_FROM_NAME);

			if (is_array($attachments)) {
				foreach ($attachments as $attachment) {
					$mail->AddAttachment("{$attachment}", '' . $attachment);             // attachment
				}
			} elseif ($attachments != '') {
				$mail->AddAttachment("{$attachments}");             // attachment
			}

			if (is_array($email)) {
				foreach ($email as $em) {
					$tmp = strpos($em, '@');
					$mail->AddAddress($em, substr($em, 0, $tmp));
				}
			} elseif ($email != '') {
				$mail->AddAddress($email, '');
			}
			// $mail->AddAddress($email, '');

			if (is_array($cc)) {
				foreach ($cc as $c) {
					$tmp = strpos($c, '@');
					$mail->AddCC($c, substr($c, 0, $tmp));
				}
			} elseif ($cc != '' || $cc !== null) {
				$mail->AddCC($cc, '');
			}
			error_log('before send');
			error_log(print_r($mail, true));

			if (!$mail->Send()) {
				error_log("not result");
				error_log(print_r($mail->ErrorInfo, true));
				error_log(print_r($mail, true));
				print_r($mail->ErrorInfo);
				die;
				$return = "Mailer Error: {$mail->ErrorInfo}";
			} else {
				error_log(print_r($mail, true));

				$return = 'Message has been sent';
			}
		} catch (phpmailerException $e) {
			print_r($e->errorMessage());
			error_log('phpmailerException');
			error_log(print_r($e->errorMessage(), true));
			error_log(print_r($e, true));

			$return = $e->errorMessage();
		}

		return $return;
	}


	public static function sendMailReports($attachments, $email, $subject, $body, $sender)
	{
		try {
			$mail = new PHPMailer();
			$mail->IsSMTP();

			$mail->SMTPAuth = false;
			$mail->SMTPSecure = '';
			$mail->Host = EMAIL_SERVER;
			$mail->Port = EMAIL_SERVER_PORT;
			$mail->Subject = $subject;
			$mail->From = EMAIL_FROM_ADDRESS;
			$mail->FromName = EMAIL_FROM_NAME;
			$mail->WordWrap = 50;
			$mail->MsgHTML($body);
			$mail->AddReplyTo(EMAIL_USER_ACC, EMAIL_FROM_NAME);

			if (is_array($attachments)) {
				foreach ($attachments as $attachment) {
					$mail->AddAttachment("{$attachment}", '' . $attachment);
				}
			} elseif ($attachments != '') {
				$mail->AddAttachment("{$attachments}");
			}

			$mail->AddAddress($email, '');
			error_log('before send');
			error_log(print_r($mail, true));

			if (!$mail->Send()) {
				error_log("not result");
				error_log(print_r($mail->ErrorInfo, true));
				error_log(print_r($mail, true));

				$return = "Mailer Error: {$mail->ErrorInfo}";
			} else {
				error_log(print_r($mail, true));

				$return = 'Message has been sent';
			}
		} catch (phpmailerException $e) {
			error_log('phpmailerException');
			error_log(print_r($e->errorMessage(), true));
			error_log(print_r($e, true));

			$return = $e->errorMessage();
		}

		return $return;
	}
}
