<?php

class PayrollCalculationUtil extends CApplicationComponent {

    public function TimesheetCalculation($model) {
        $Timesheet = new Timesheet;

        $updated = strtotime($model->PunchTime);
        $punchdate = date('Y-m-d', $updated);
        $PunchDate = (string) $punchdate;
        $EmployeeId = (string) $model->Employeeid;

        $employeesalary = Employeesalary::model()->findByAttributes(array('employeeid' => $model->Employeeid, 'Status' => 1));

        $Criteria1 = new CDbCriteria();

        $Criteria1->condition = 'date(PunchTime)= :punchdate AND Employeeid = :employeeid';
        $Criteria1->params = array(':punchdate' => $PunchDate, ':employeeid' => $EmployeeId);
        $Criteria1->limit = 1;
        $Criteria1->order = "id ASC";
        $Criteria1->select = "*";
        $IntimeTimelog = Timelog::model()->findAll($Criteria1);

        $Criteria2 = new CDbCriteria();
        $Criteria2->condition = 'date(PunchTime)= :punchdate AND Employeeid = :employeeid';
        $Criteria2->params = array(':punchdate' => $PunchDate, ':employeeid' => $EmployeeId);
        $Criteria2->limit = 1;
        $Criteria2->order = "id DESC";
        $Criteria2->select = "*";
        $LasttimeTimelog = Timelog::model()->findAll($Criteria2);


        $Schedule = Schedule::model()->findByAttributes(array('Date' => $punchdate));
        if (!empty($Schedule)) {
            $employeeshiftlist = EmployeeShift::model()->findAllByAttributes(array('EmployeeId' => $model->Employeeid, 'schedulid' => $Schedule->id));
            foreach ($employeeshiftlist as $employeeshift) {
            if (!empty($employeeshift)) {
               
                $shiftid = $employeeshift->ShiftId;
                $shift = Shift::model()->findByAttributes(array('id' => $shiftid));
                $ShiftStartTime = date('H:i:s', strtotime($shift->StartTime));
                $intime = date('H:i:s', strtotime($IntimeTimelog[0]->PunchTime));


                $StartTime = null;

                if ($ShiftStartTime < $intime) {
                    $StartTime = $IntimeTimelog[0]->PunchTime;
                } else {
                    $StartTime = $shift->StartTime;
                }

                $ts1 = strtotime(str_replace('/', '-', $StartTime));
                $ts2 = strtotime(str_replace('/', '-', $LasttimeTimelog[0]->PunchTime));
                $timerange = ($ts2 - $ts1 ) / 3600;
                $diffhours = $timerange > 0 ? $timerange : 0;

                $ShiftStime = strtotime(str_replace('/', '-', $shift->StartTime));
                $ShiftEtime = strtotime(str_replace('/', '-', $shift->EndTime));
                $Shifthour = abs($ShiftStime - $ShiftEtime) / 3600;
                $shiftworkinghour = $Shifthour - 1;

                $ShiftHourlyRate = $shift->salaryRate;
                $ShiftNOTRate = $shift->FirstOTRate;
                $ShiftDOTRate = $shift->SecondOTRate;
                $NotRang = $shift->FirstOTTimeRang;
                $DotRang = $shift->SecondOTRange;

                $OTHour = $diffhours - $Shifthour;
                $ShiftAndNOTHour = $Shifthour + $NotRang;
                $SecondOTHour = $diffhours - $ShiftAndNOTHour;


                $Timesheetforemployee = Timesheet::model()->findByAttributes(array('EmployeeShiftid' => $employeeshift->id));
                if (empty($Timesheetforemployee)) {

                    $Timesheet->Intime = $IntimeTimelog[0]->PunchTime;
                    $Timesheet->EmployeeId = $model->Employeeid;
                    $Timesheet->date = $punchdate;
                    $Timesheet->OuteTime = $LasttimeTimelog[0]->PunchTime;

                    if ($Shifthour >= $diffhours) {

                        $Timesheet->SallaryRate = $ShiftHourlyRate * ($diffhours * $employeesalary->HourlyRate);
                        $Timesheet->NOvertimeHours = 0;
                        $Timesheet->DOverTimeHour = 0;
                        $Timesheet->Dovertimesalary = 0;
                        $Timesheet->NOvertimeSalary = 0;
                    } else {

                        $Timesheet->SallaryRate = $ShiftHourlyRate * ($shiftworkinghour * $employeesalary->HourlyRate);

                        $OTHour = $diffhours - $Shifthour;

                        $Timesheet->NOvertimeHours = $OTHour <= $NotRang ? $OTHour : $NotRang;
                        $Timesheet->NOvertimeSalary = $OTHour >= $NotRang ? $ShiftNOTRate * ($NotRang * $employeesalary->HourlyRate) : $ShiftNOTRate * ($OTHour * $employeesalary->HourlyRate);

                        if ($diffhours > $ShiftAndNOTHour) {
                            $Timesheet->DOverTimeHour = $SecondOTHour <= $DotRang ? $SecondOTHour : $DotRang;
                            $Timesheet->Dovertimesalary = $SecondOTHour <= $DotRang ? $ShiftDOTRate * ($SecondOTHour * $employeesalary->HourlyRate) : $ShiftDOTRate * ($DotRang * $employeesalary->HourlyRate);
                        } else {
                            $Timesheet->DOverTimeHour = 0;
                            $Timesheet->Dovertimesalary = 0;
                        }
                    }

                    $Timesheet->EmployeeShiftid = $employeeshift->id;
                    $employeedesignation = EmployeeDesignation::model()->findByAttributes(array('EmployeeId' => $model->Employeeid));
                    $Timesheet->DesignaId = $employeedesignation->DesignationId;

                    $Timesheet->save();
                } else {

                    if ($Shifthour >= $diffhours) {
                        $salary = $ShiftHourlyRate * ($diffhours * $employeesalary->HourlyRate);
                        Timesheet::model()->updateAll(array('SallaryRate' => $salary, 'OuteTime' => $LasttimeTimelog[0]->PunchTime), 'id ="' . $Timesheetforemployee->id . '"');
                    } else {
                        $ShiftSallary = $ShiftHourlyRate * ($shiftworkinghour * $employeesalary->HourlyRate);


                        $NOTHour = $OTHour >= $NotRang ? $NotRang : $OTHour;
                        $NOTAmount = $OTHour >= $NotRang ? $ShiftNOTRate * ($NotRang * $employeesalary->HourlyRate) : $ShiftNOTRate * ($OTHour * $employeesalary->HourlyRate);

                        if ($diffhours > $ShiftAndNOTHour) {
                            $DOTHour = $SecondOTHour <= $DotRang ? $SecondOTHour : $DotRang;
                            $DOTSallary = $SecondOTHour <= $DotRang ? $ShiftDOTRate * ($SecondOTHour * $employeesalary->HourlyRate) : $ShiftDOTRate * ($DotRang * $employeesalary->HourlyRate);

                            Timesheet::model()->updateAll(array('OuteTime' => $LasttimeTimelog[0]->PunchTime, 'DOverTimeHour' => $DOTHour, 'Dovertimesalary' => $DOTSallary), 'id ="' . $Timesheetforemployee->id . '"');
                        }

                        Timesheet::model()->updateAll(array('OuteTime' => $LasttimeTimelog[0]->PunchTime, 'SallaryRate' => $ShiftSallary, 'NOvertimeHours' => $NOTHour, 'NOvertimeSalary' => $NOTAmount), 'id ="' . $Timesheetforemployee->id . '"');
                    }
                }
            }
          } 
        }
    }

    public function TimesheetCreateByshift($EmployeeShift, $IntimeTimelog, $LasttimeTimelog, $SheduleDate) {

        $Timesheet = new Timesheet;

        $shiftid = $EmployeeShift->ShiftId;
        $shift = Shift::model()->findByAttributes(array('id' => $shiftid));
        $ShiftStartTime = date('H:i:s', strtotime($shift->StartTime));
        $intime = date('H:i:s', strtotime($IntimeTimelog[0]->PunchTime));

        $employeesalary = Employeesalary::model()->findByAttributes(array('employeeid' => $EmployeeShift->EmployeeId, 'Status' => 1));

        $StartTime = null;

        if ($ShiftStartTime < $intime) {
            $StartTime = $IntimeTimelog[0]->PunchTime;
        } else {
            $StartTime = $shift->StartTime;
        }

        $ts1 = strtotime(str_replace('/', '-', $StartTime));
        $ts2 = strtotime(str_replace('/', '-', $LasttimeTimelog[0]->PunchTime));
        $timerange = ($ts2 - $ts1 ) / 3600;
        $diffhours = $timerange > 0 ? $timerange : 0;

        $ShiftStime = strtotime(str_replace('/', '-', $shift->StartTime));
        $ShiftEtime = strtotime(str_replace('/', '-', $shift->EndTime));
        $Shifthour = abs($ShiftStime - $ShiftEtime) / 3600;
        $shiftworkinghour = $Shifthour - 1;

        $ShiftHourlyRate = $shift->salaryRate;
        $ShiftNOTRate = $shift->FirstOTRate;
        $ShiftDOTRate = $shift->SecondOTRate;
        $NotRang = $shift->FirstOTTimeRang;
        $DotRang = $shift->SecondOTRange;

        $OTHour = $diffhours - $Shifthour;
        $ShiftAndNOTHour = $Shifthour + $NotRang;
        $SecondOTHour = $diffhours - $ShiftAndNOTHour;


        $Timesheet->Intime = $IntimeTimelog[0]->PunchTime;
        $Timesheet->EmployeeId = $EmployeeShift->EmployeeId;
        $Timesheet->date = $SheduleDate;
        $Timesheet->OuteTime = $LasttimeTimelog[0]->PunchTime;

        if ($Shifthour >= $diffhours) {

            $Timesheet->SallaryRate = $ShiftHourlyRate * ($diffhours * $employeesalary->HourlyRate);
            $Timesheet->NOvertimeHours = 0;
            $Timesheet->DOverTimeHour = 0;
            $Timesheet->Dovertimesalary = 0;
            $Timesheet->NOvertimeSalary = 0;
        } else {
            $Timesheet->SallaryRate = $ShiftHourlyRate * ($shiftworkinghour * $employeesalary->HourlyRate);

            $OTHour = $diffhours - $Shifthour;

            $Timesheet->NOvertimeHours = $OTHour <= $NotRang ? $OTHour : $NotRang;
            $Timesheet->NOvertimeSalary = $OTHour >= $NotRang ? $ShiftNOTRate * ($NotRang * $employeesalary->HourlyRate) : $ShiftNOTRate * ($OTHour * $employeesalary->HourlyRate);

            if ($diffhours > $ShiftAndNOTHour) {
                $Timesheet->DOverTimeHour = $SecondOTHour <= $DotRang ? $SecondOTHour : $DotRang;
                $Timesheet->Dovertimesalary = $SecondOTHour <= $DotRang ? $ShiftDOTRate * ($SecondOTHour * $employeesalary->HourlyRate) : $ShiftDOTRate * ($DotRang * $employeesalary->HourlyRate);
            } else {
                $Timesheet->DOverTimeHour = 0;
                $Timesheet->Dovertimesalary = 0;
            }
        }

        $Timesheet->EmployeeShiftid = $EmployeeShift->id;
        $employeedesignation = EmployeeDesignation::model()->findByAttributes(array('EmployeeId' => $EmployeeShift->EmployeeId));
        $Timesheet->DesignaId = $employeedesignation->DesignationId;

        $Timesheet->save();
        // print_r($designationsalary->id);
        // die;
    }

    public function TimesheetCalculation1($model, $Timesheetforemployee) {
        $Timesheet = new Timesheet;
        $Employeeid = $model->Employeeid;
        $mployShiftid = $Timesheetforemployee->EmployeeShiftid;

        $employeesalary = Employeesalary::model()->findByAttributes(array('employeeid' => $Employeeid, 'Status' => 1));
        $employeeshift = EmployeeShift::model()->findByAttributes(array('id' => $mployShiftid));

        $shiftid = $employeeshift->ShiftId;
        $shift = Shift::model()->findByAttributes(array('id' => $shiftid));

        $ShiftStartTime = strtotime($shift->StartTime);
        $ShiftEndTime = strtotime($shift->EndTime);
        $ShiftHourlyRate = $shift->salaryRate;
        $ShiftOTRate = $shift->OTRate;


        $intime = strtotime($Timesheetforemployee->Intime);
        $StartTime = null;

        if ($ShiftStartTime < $intime) {
            $StartTime = $Timesheetforemployee->Intime;
        } else {
            $StartTime = $shift->StartTime;
        }

        $ts1 = strtotime(str_replace('/', '-', $StartTime));
        $ts2 = strtotime(str_replace('/', '-', $model->PunchTime));
        $diffhours = abs($ts1 - $ts2) / 3600;

        $St1 = strtotime(str_replace('/', '-', $ShiftStartTime));
        $St2 = strtotime(str_replace('/', '-', $ShiftEndTime));
        $ShiftHour = abs($St1 - $St2) / 3600;

        $Timesheet->OuteTime = $model->PunchTime;

        if ($ShiftHour >= $diffhours) {

            $salary = $ShiftHourlyRate * ($diffhours * $employeesalary->HourlyRate);
            Timesheet::model()->updateAll(array('SallaryRate' => $salary, 'OuteTime' => $model->PunchTime), 'id ="' . $Timesheetforemployee->id . '"');
        } else {

            $NOTHour = $diffhours - $ShiftHour;
            $NOTamount = $ShiftOTRate * ($NOTHour * $employeesalary->OTRate);
            Timesheet::model()->updateAll(array('OuteTime' => $model->PunchTime, 'NOvertimeHours' => $NOTHour, 'NOvertimeSalary' => $NOTamount), 'id ="' . $Timesheetforemployee->id . '"');
        }
    }

    public function GetStartTimeLOg($SheduleDate, $employeeid) {
        $Sheduldate = (string) $SheduleDate;
        $EmployeeId = (string) $employeeid;
        $Criteria1 = new CDbCriteria();

        $Criteria1->condition = 'date(PunchTime)= :punchdate AND Employeeid = :employeeid';
        $Criteria1->params = array(':punchdate' => $Sheduldate, ':employeeid' => $EmployeeId);
        $Criteria1->limit = 1;
        $Criteria1->order = "id ASC";
        $Criteria1->select = "*";
        return $IntimeTimelog = Timelog::model()->findAll($Criteria1);
    }

    public function GetEndTimeLOg($SheduleDate, $employeeid) {
        $Sheduldate = (string) $SheduleDate;
        $EmployeeId = (string) $employeeid;
        $Criteria2 = new CDbCriteria();
        $Criteria2->condition = 'date(PunchTime)= :punchdate AND Employeeid = :employeeid';
        $Criteria2->params = array(':punchdate' => $Sheduldate, ':employeeid' => $EmployeeId);
        $Criteria2->limit = 1;
        $Criteria2->order = "id DESC";
        $Criteria2->select = "*";
        return $LasttimeTimelog = Timelog::model()->findAll($Criteria2);
    }

    public function TimesheetRecalculate($TimeSheetid) {

        $Timesheet = Timesheet::model()->findByAttributes(array('id' => $TimeSheetid));

        $outtime = $Timesheet->OuteTime;
        $intime = $Timesheet->Intime;
        $emshiftid = $Timesheet->EmployeeShiftid;

        $employeeshift = EmployeeShift::model()->findByAttributes(array('id' => $emshiftid));
        $Shiftid = $employeeshift->ShiftId;

        $shift = Shift::model()->findByAttributes(array('id' => $Shiftid));
        $ShiftStartTime = $shift->StartTime;

        $employeesalary = Employeesalary::model()->findByAttributes(array('employeeid' => $Timesheet->EmployeeId, 'Status' => 1));

        $StartTime = null;

        if ($ShiftStartTime < $intime) {
            $StartTime = $intime;
        } else {
            $StartTime = $ShiftStartTime;
        }

        $ts1 = strtotime(str_replace('/', '-', $StartTime));
        $ts2 = strtotime(str_replace('/', '-', $outtime));
        $timerange = ($ts2 - $ts1 ) / 3600;
        $diffhours = $timerange > 0 ? $timerange : 0;

        $ShiftStime = strtotime(str_replace('/', '-', $shift->StartTime));
        $ShiftEtime = strtotime(str_replace('/', '-', $shift->EndTime));
        $Shifthour = abs($ShiftStime - $ShiftEtime) / 3600;
        $shiftworkinghour = $Shifthour - 1;

        $ShiftHourlyRate = $shift->salaryRate;
        $ShiftNOTRate = $shift->FirstOTRate;
        $ShiftDOTRate = $shift->SecondOTRate;
        $NotRang = $shift->FirstOTTimeRang;
        $DotRang = $shift->SecondOTRange;

        $OTHour = $diffhours - $Shifthour;
        $ShiftAndNOTHour = $Shifthour + $NotRang;
        $SecondOTHour = $diffhours - $ShiftAndNOTHour;

        $SallaryRate = null;
        $NOvertimeHours = null;
        $NOvertimeSalary = null;
        $DOverTimeHour = null;
        $Dovertimesalary = null;


        if ($Shifthour >= $diffhours) {

            $SallaryRate = $ShiftHourlyRate * ($diffhours * $employeesalary->HourlyRate);
            $NOvertimeHours = 0;
            $DOverTimeHour = 0;
            $Dovertimesalary = 0;
            $NOvertimeSalary = 0;
        } else {
            $SallaryRate = $ShiftHourlyRate * ($shiftworkinghour * $employeesalary->HourlyRate);

            $OTHour = $diffhours - $Shifthour;

            $NOvertimeHours = $OTHour <= $NotRang ? $OTHour : $NotRang;
            $NOvertimeSalary = $OTHour >= $NotRang ? $ShiftNOTRate * ($NotRang * $employeesalary->HourlyRate) : $ShiftNOTRate * ($OTHour * $employeesalary->HourlyRate);

            if ($diffhours > $ShiftAndNOTHour) {
                $DOverTimeHour = $SecondOTHour <= $DotRang ? $SecondOTHour : $DotRang;
                $Dovertimesalary = $SecondOTHour <= $DotRang ? $ShiftDOTRate * ($SecondOTHour * $employeesalary->HourlyRate) : $ShiftDOTRate * ($DotRang * $employeesalary->HourlyRate);
            } else {
                $DOverTimeHour = 0;
                $Dovertimesalary = 0;
            }
        }

        Timesheet::model()->updateAll(array('SallaryRate' => $SallaryRate, 'NOvertimeHours' => $NOvertimeHours, 'NOvertimeSalary' => $NOvertimeSalary, 'DOverTimeHour' => $DOverTimeHour, 'Dovertimesalary' => $Dovertimesalary,), "id=" . $TimeSheetid . "");
    }

}
