<?php

require ('OAuth2RestLib/Client.php');


class AccountsController extends Controller
{
/**
* @var string the default layout for the views. Defaults to '//layouts/column2', meaning
* using two-column layout. See 'protected/views/layouts/column2.php'.
*/
public $layout='//layouts/column1';

/**
* @return array action filters
*/
public function filters()
{
return array(
'accessControl', // perform access control for CRUD operations
);
}

/**
* Specifies the access control rules.
* This method is used by the 'accessControl' filter.
* @return array access control rules
*/
public function accessRules()
{
return array(
array('allow',  // allow all users to perform 'index' and 'view' actions
'actions'=>array('index','view','test'),
'users'=>array('*'),
),
array('allow', // allow authenticated user to perform 'create' and 'update' actions
'actions'=>array('create','update'),
'users'=>array('@'),
),
array('allow', // allow admin user to perform 'admin' and 'delete' actions
'actions'=>array('admin','delete'),
'users'=>array('admin'),
),
array('deny',  // deny all users
'users'=>array('*'),
),
);
}

/**
* Displays a particular model.
* @param integer $id the ID of the model to be displayed
*/
public function actionView($id)
{
$this->render('view',array(
'model'=>$this->loadModel($id),
));
}

/**
* Creates a new model.
* If creation is successful, the browser will be redirected to the 'view' page.
*/
public function actionCreate()
{
$model=new Accounts;

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['Accounts']))
{
$model->attributes=$_POST['Accounts'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('create',array(
'model'=>$model,
));
}

/**
* Updates a particular model.
* If update is successful, the browser will be redirected to the 'view' page.
* @param integer $id the ID of the model to be updated
*/
public function actionUpdate($id)
{
$model=$this->loadModel($id);

// Uncomment the following line if AJAX validation is needed
// $this->performAjaxValidation($model);

if(isset($_POST['Accounts']))
{
$model->attributes=$_POST['Accounts'];
if($model->save())
$this->redirect(array('view','id'=>$model->id));
}

$this->render('update',array(
'model'=>$model,
));
}

/**
* Deletes a particular model.
* If deletion is successful, the browser will be redirected to the 'admin' page.
* @param integer $id the ID of the model to be deleted
*/
public function actionDelete($id)
{
if(Yii::app()->request->isPostRequest)
{
// we only allow deletion via POST request
$this->loadModel($id)->delete();

// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
if(!isset($_GET['ajax']))
$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
}
else
throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
}

/**
* Lists all models.
*/
public function actionIndex()
{
$dataProvider=new CActiveDataProvider('Accounts');
$this->render('index',array(
'dataProvider'=>$dataProvider,
));
}


public function actionTest(){

//Client Credentials
$client_id = 'EVVH3RJV4F2JYHO4';
$client_secret = '2qUOUaBRBvwD0C9SHBVpz8OYjK9djN24fuyQTtj5IyE9fhJc';
$username = 'lasitha.kumara@eimsky.com';
$password = 'Password@1234';
$api_key = 'QS0ZpXSoX36i5ZtqscVUt240s9rxFi7u5WWDT6TS';

//Resources that you need to access

$event_id = 1;

$resourceURL1 = 'https://iovprd.nimbusventure.com/restservices/companies/jsp/fleets/1/geo_fences/1516614219?status=history&start=2018-01-06%2018:30&end=2018-02-07%2018:30';
//$resourceURL2 = 'https://iov.nimbusventure.com/restservices/companies/jsp/fleets?$event_id';
//$resourceURL3 = 'https://iov.nimbusventure.com/restservices/companies/demo/fleets/29';
//$resourceURL4 = 'https://iov.nimbusventure.com/restservices/companies/demo/fleets/29/vehicles';

//Allowed HTTP Method
$http_method = 'GET';

//Initialize client object
$client = new OAuth2RestLib\Client($client_id,$client_secret,$username,$password);


$response_1 = $client->queryResource($resourceURL1,$http_method,$api_key);    
echo $response_1;


}

/**
* Manages all models.
*/
public function actionAdmin()
{
$model=new Accounts('search');
$model->unsetAttributes();  // clear any default values
if(isset($_GET['Accounts']))
$model->attributes=$_GET['Accounts'];

$this->render('admin',array(
'model'=>$model,
));
}

/**
* Returns the data model based on the primary key given in the GET variable.
* If the data model is not found, an HTTP exception will be raised.
* @param integer the ID of the model to be loaded
*/
public function loadModel($id)
{
$model=Accounts::model()->findByPk($id);
if($model===null)
throw new CHttpException(404,'The requested page does not exist.');
return $model;
}

/**
* Performs the AJAX validation.
* @param CModel the model to be validated
*/
protected function performAjaxValidation($model)
{
if(isset($_POST['ajax']) && $_POST['ajax']==='accounts-form')
{
echo CActiveForm::validate($model);
Yii::app()->end();
}
}
}
